<?php
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

class Api {

    function curl_send($method, $url, $data = null, $token = null) {
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        //curl_setopt($curl, $method, true);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        if ($token){
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Authorization: Bearer ' . $token,
                'Content-Type: application/json'
            ));
        }else{
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json'
            ));
        }

        if ($data) {
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        }

        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        $response = curl_exec($curl);
        // Ottieni il codice di stato HTTP
        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        curl_close($curl);

        if ($ris = json_decode($response)){
            $ris->stato=$http_code;
            return $ris;
        }else{
            return $response;
        }
        
    }

    //Esegue la validazione dell'ApiKey e restituisce il token di accesso
    function getApiToken($apiKey){
        $url = "https://apitest.icegiri.it/login";
        
        $data = json_decode("{}");
        $data->apiKey = $apiKey;
        $data=json_encode($data);

        $resp = $this->curl_send("POST", $url, $data);
        if (!isset($resp->valid)){
            return($resp);
        }
        if ($resp->valid){
            return($resp->access_token);
        }else{
            return(false);
        }
    }

    //Restituisce valid=true se il token è ancora valido
    function getConnected($token){
        $url = "https://apitest.icegiri.it/connected";
        
        $resp = $this->curl_send("GET", $url, null, $token);
        if (!isset($resp->valid)){
            return($resp);
        }
        return($resp);
    }

    
    ////////////////////////////////////////////////
    ///////    Funzioni per articoli       /////////
    ////////////////////////////////////////////////

    //Esempio di inserimento
    function insertArticoli($token){
        $url = "https://apitest.icegiri.it/tab/create/articoli/";
        
        $data = json_decode("[]");
        //Aggiungo un articolo con tutti i campi
        $articolo1 = json_decode("{}");
        $articolo1->Codice = "ART01";
        $articolo1->DescArticolo = "Articolo 1";
        $articolo1->UnitaMisura = "PZ";
        $articolo1->CodiceIva = "IVA22";
        $articolo1->AliquotaIva = 22;
        $articolo1->Marca = "Marca 1";
        $articolo1->Listino = 10.00;
        $articolo1->ArticoliCollo = 1;
        $articolo1->Peso = 3.5;
        array_push($data, $articolo1);

        //Aggiungo un articolo con solo i campi obbligatori
        $articolo2 = json_decode("{}");
        $articolo2->Codice = "ART02";
        $articolo2->DescArticolo = "Articolo 2";
        $articolo2->UnitaMisura = "PZ";
        $articolo2->CodiceIva = "N1";
        $articolo2->AliquotaIva = 0;
        array_push($data, $articolo2);

        $data=json_encode($data);

        $resp = $this->curl_send("POST", $url, $data, $token);
        
        return($resp);
    }

    //Esempio di eliminazione di un nuovo utente
    function deleteArticolo($token){
        $url = "https://apitest.icegiri.it/tab/delete/articoli";
        
        $data = json_decode("{}");
        $data->Codice = 'ART02';
        $data = json_encode($data);

        $resp = $this->curl_send("DELETE", $url, $data, $token);
        return($resp);
    }

    //Esempio di lettura elenco
    // return: array di oggetti dove ogni oggetto è un record, nella proprietà recordset
    function getArticoli($token, $start=0, $limit=0){
        if ($limit>0){
            $url = "https://apitest.icegiri.it/tab/read/articoli/$start/$limit";
        }else{
            $url = "https://apitest.icegiri.it/tab/read/articoli";
        }
        
        $resp = $this->curl_send("GET", $url, null, $token);
        return($resp);
    }

    //Esempio di lettura singolo record
    // return: un oggetto record nella proprietà record
    function getArticolo($token, $id){
        $url = "https://apitest.icegiri.it/tab/read/articoli/$id";
        
        $resp = $this->curl_send("GET", $url, null, $token);
        return($resp);
    }


    ////////////////////////////////////////////////
    ///////    Funzioni per clienti        /////////
    ////////////////////////////////////////////////

    //Esempio di inserimento
    function insertClienti($token){
        $url = "https://apitest.icegiri.it/tab/create/clienti";
        
        $data = json_decode("[]");
        //Aggiungo un articolo con tutti i campi
        $cliente1 = json_decode("{}");
        $cliente1->Codice = 1;
        $cliente1->DescCliente = "Cliente 1";
        $cliente1->Indirizzo = "Via Roma 1";
        $cliente1->Cap = "00118";
        $cliente1->Comune = "Roma";
        $cliente1->Provincia = "RM";
        $cliente1->PartitaIva = "12345678901";
        $cliente1->CodiceFiscale = "12345678901";
        $cliente1->Telefono = "021234567";
        $cliente1->Cellulare = "3381234567";
        $cliente1->Email = "cliente1@email.it";

        array_push($data, $cliente1);

        //Aggiungo un articolo con solo i campi obbligatori
        $cliente2 = json_decode("{}");
        $cliente2->Codice = 2;
        $cliente2->DescCliente = "Cliente 2";
        $cliente2->Indirizzo = "Via Roma 2";
        $cliente2->Cap = "00119";
        $cliente2->Comune = "Roma";
        $cliente2->Provincia = "RM";
        $cliente2->PartitaIva = "12345678901";
        $cliente2->CodiceFiscale = "12345678901";
        array_push($data, $cliente2);

        $data=json_encode($data);

        $resp = $this->curl_send("POST", $url, $data, $token);
        return($resp);
    }

    //Esempio di eliminazione di un nuovo utente
    function deleteCliente($token){
        $url = "https://apitest.icegiri.it/tab/delete/clienti";
        
        $data = json_decode("{}");
        $data->Codice = 2;
        $data = json_encode($data);

        $resp = $this->curl_send("DELETE", $url, $data, $token);
        return($resp);
    }

    //Esempio di lettura elenco
    // return: array di oggetti dove ogni oggetto è un record, nella proprietà recordset
    function getClienti($token, $start=0, $limit=0){
        if ($limit>0){
            $url = "https://apitest.icegiri.it/tab/read/clienti/$start/$limit";
        }else{
            $url = "https://apitest.icegiri.it/tab/read/clienti";
        }
        
        $resp = $this->curl_send("GET", $url, null, $token);
        return($resp);
    }

    //Esempio di lettura singolo record
    // return: un oggetto record nella proprietà record
    function getCliente($token, $id){
        $url = "https://apitest.icegiri.it/tab/read/clienti/$id";
        
        $resp = $this->curl_send("GET", $url, null, $token);
        return($resp);
    }

    ////////////////////////////////////////////////
    ///////    Funzioni per documenti        ///////
    ////////////////////////////////////////////////

    //Esempio di inserimento
    function insertDocumenti($token){
        $url = "https://apitest.icegiri.it/doc/create/ord";
        //per i ddt: $url = "https://apitest.icegiri.it/doc/create/ddt";
        
        $data = json_decode("[]");
        
        //Aggiungo un documento con tutti i campi
        $doc1 = json_decode("{}");
        $doc1->Numero = 1;
        $doc1->Data = "01/04/2025";
        $doc1->Prefisso = "";
        $doc1->Suffisso = "/2025";
        $doc1->CodiceCliente = "2";
        $doc1->Destinazione = 1;
        $doc1->DiversaDestinazione = json_decode("{}");
        $doc1->DiversaDestinazione->DiversoDestinatario = "Azienda diversa";
        $doc1->DiversaDestinazione->DiversoIndirizzo = "Via Milano, 2";
        $doc1->DiversaDestinazione->DiversoCap = "20121";
        $doc1->DiversaDestinazione->DiversaProvincia = "MI";
        $doc1->DiversaDestinazione->DiversoComune = "Milano";
        $doc1->Colli = 1;
        $doc1->Peso = 2.5;
        $doc1->Trasporto = "Mittente";
        $doc1->Porto = "Franco";
        $doc1->DataTrasporto = "02/04/2025";
        $doc1->OraTrasporto = "10:30";
        $doc1->DataConsegna = "03/04/2025";
        $doc1->AspettoEsteriore = "Scatole";
        $doc1->CausaleTrasporto = "Vendita";
        $doc1->Sconto1 = 0;
        $doc1->Sconto2 = 0;
        $doc1->Sconto3 = 0;
        $doc1->Sconto4 = 0;
        $doc1->Note = "Note per la vendita";
        $doc1->Vettore = json_decode("{}");
        $doc1->Vettore->DescVettore = "Vottore 1";
        $doc1->Vettore->Indirizzo = "Via Vettore, 2";
        $doc1->Vettore->Cap = "90018";
        $doc1->Vettore->Provincia = "PA";
        $doc1->Vettore->Comune = "Palermo";

        $movimenti = json_decode("[]");
        //Articolo con tutti i campi
        $mov1 = json_decode("{}");
        $mov1->Codice = "ART01";
        $mov1->DescMovimento = "Articolo 1";
        $mov1->UnitaMisura = "PZ";
        $mov1->Quantita = 2;
        $mov1->PrezzoUnitario = 12;
        $mov1->Sconto1 = 20;
        $mov1->Sconto2 = 0;
        $mov1->Importo = 19.2;
        $mov1->CodiceIva = "Iva22";
        $mov1->AliquotaIva = 22;
        $mov1->Lotto = "Lotto1";
        $mov1->Scadenza = "25/05/2025";
        $mov1->PesoUnitario = 1.5;
        $mov1->PesoMovimento = 3;
        array_push($movimenti, $mov1);

        //Articolo con tutti i campi
        $mov2 = json_decode("{}");
        $mov2->Codice = "ART02";
        $mov2->DescMovimento = "Articolo 2";
        $mov2->UnitaMisura = "PZ";
        $mov2->Quantita = 2;
        $mov2->Lotto = "Lotto2";
        $mov2->Scadenza = "25/05/2025";
        array_push($movimenti, $mov2);

        $doc1->Movimenti = $movimenti;

        array_push($data, $doc1);

        //Aggiungo un documento con solo i campi obbligatori
        $doc2 = json_decode("{}");
        $doc2->Numero = 2;
        $doc2->Data = "02/04/2025";
        $doc2->CodiceCliente = "3";
        $doc2->Destinazione = 0;  //0 = IDEM, indirizzo dell'anagrafica cliente
        

        $movimenti = json_decode("[]");
        //Articolo con tutti i campi
        $mov1 = json_decode("{}");
        $mov1->Codice = "ART01";
        $mov1->DescMovimento = "Articolo 1";
        $mov1->UnitaMisura = "PZ";
        $mov1->Quantita = 2;
        $mov1->PrezzoUnitario = 12;
        $mov1->Sconto1 = 20;
        $mov1->Sconto2 = 0;
        $mov1->Importo = 19.2;
        $mov1->CodiceIva = "Iva22";
        $mov1->AliquotaIva = 22;
        $mov1->Lotto = "Lotto1";
        $mov1->Scadenza = "25/05/2025";
        $mov1->PesoUnitario = 1.5;
        $mov1->PesoMovimento = 3;
        array_push($movimenti, $mov1);

        //Articolo con tutti i campi
        $mov2 = json_decode("{}");
        $mov2->Codice = "ART02";
        $mov2->DescMovimento = "Articolo 2";
        $mov2->UnitaMisura = "PZ";
        $mov2->Quantita = 1;
        $mov2->Lotto = "Lotto2";
        $mov2->Scadenza = "25/05/2025";
        array_push($movimenti, $mov2);

        $doc2->Movimenti = $movimenti;

        array_push($data, $doc2);

        $dataObj = json_decode("{}");
        $dataObj->documenti = $data;

        $data=json_encode($dataObj);

        $resp = $this->curl_send("POST", $url, $data, $token);
        return($resp);
    }

    function deleteDocumentiLetti($token){
        $url = "https://apitest.icegiri.it/doc/delete/ddt";
        
        /*
        $data = json_decode("{}");
        $data->Letti = true;
        $data=json_encode($data);
        */

        $resp = $this->curl_send("DELETE", $url, null, $token);
        return($resp);
    }

    //Esempio di eliminazione di un nuovo utente
    function deleteDocumento($token){
        $url = "https://apitest.icegiri.it/doc/delete/ord";
        //per i ddt: $url = "https://apitest.icegiri.it/doc/delete/ddt";
        
        $data = json_decode("{}");
        $data->Numero = 2;
        $data->Data = "02/04/2025";
        $data->Pefisso = "";
        $data->Suffisso = "";
        $data = json_encode($data);

        $resp = $this->curl_send("DELETE", $url, $data, $token);
        return($resp);
    }

    //Esempio di lettura elenco
    // return: array di oggetti dove ogni oggetto è un record, nella proprietà recordset
    function getDocumenti($token, $start=0, $limit=0){
        /* elenco degli endpoint per ogni tipo di documento:
        ordini: https://apitest.icegiri.it/doc/read/ord
        ddt di spedizione: https://apitest.icegiri.it/doc/read/dda
        ddt di consegna a cliente: https://apitest.icegiri.it/doc/read/ddt
        */
        if ($limit>0){
            $url = "https://apitest.icegiri.it/doc/read/ord/$start/$limit";
        }else{
            $url = "https://apitest.icegiri.it/doc/read/ord";
        }
        
        $resp = $this->curl_send("GET", $url, null, $token);
        

        ////////
        // Inserire qui il codice per gestire i record scaricati
        // ...........
        ///////

        //SOLO quando si leggono i dda (ddt di consegna ricevuti da Icetime)
        //Bisogna richiamare la funzione che Elimina i documenti scaricati con spunta letto
        $this->deleteDocumentiLetti($token);
        return($resp);
    }

    //Esempio di lettura singolo record
    // return: un oggetto record nella proprietà record
    function getDocumento($token, $id){
        $url = "https://apitest.icegiri.it/doc/read/ord/$id";
        
        $resp = $this->curl_send("GET", $url, null, $token);
        return($resp);
    }


    //Esempio di lettura elenco documenti eliminati
    // return: array di oggetti dove ogni oggetto è un record, nella proprietà recordset
    function getDocumentiEliminati($token, $start=0, $limit=0){
        /* elenco degli endpoint per ogni tipo di documento:
        ordini: https://apitest.icegiri.it/doc-eliminati/read/ord
        ddt di spedizione: https://apitest.icegiri.it/doc-eliminati/read/dda
        ddt di consegna a cliente: https://apitest.icegiri.it/doc-eliminati/read/ddt
        */
        if ($limit>0){
            $url = "https://apitest.icegiri.it/doc-eliminati/read/ddt/$start/$limit";
        }else{
            $url = "https://apitest.icegiri.it/doc-eliminati/read/ddt";
        }
        
        $resp = $this->curl_send("GET", $url, null, $token);
        
        return($resp);
    }

    function deleteDocumentiEliminatiLetti($token){
        $url = "https://apitest.icegiri.it/doc-eliminati/delete/ddt";
        
        $resp = $this->curl_send("DELETE", $url, null, $token);
        return($resp);
    }
}

?>